struct VS_OUTPUT {
    float4 position   : POSITION;
    float4 color      : COLOR0;
    float2 uv         : TEXCOORD0;
};

float4x4 object_to_proj_matrix;


texture diffuse_texture;

sampler DiffuseTextureSampler = 
sampler_state {
    Texture = <diffuse_texture>;    
    MipFilter = LINEAR;
    MinFilter = POINT;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
};

VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0,
                        float2 uv: TEXCOORD0) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;
    output.uv = uv;
    return output;
}


struct PS_OUTPUT {
    float4 color : COLOR0;  // Pixel color    
};


PS_OUTPUT pixel_shader(VS_OUTPUT input) {
    PS_OUTPUT output;

    float4 texture_color = tex2D(DiffuseTextureSampler, input.uv);

    output.color = input.color * texture_color;
//    output.color = float4(1, 1, 1, 1);
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_1_1 pixel_shader();

        AlphaBlendEnable = True;
        SrcBlend = One;  
        DestBlend = InvSrcAlpha;
        AlphaTestEnable = True;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}


