struct VS_OUTPUT {
    float4 position   : POSITION;
    float4 color      : COLOR0;
    float2 uv1        : TEXCOORD0;
    float2 uv2        : TEXCOORD1;
};

float4x4 object_to_proj_matrix;


texture texture1;
texture texture2;

sampler Sampler1 = 
sampler_state {
    Texture = <texture1>;
    MipFilter = LINEAR;
    MinFilter = POINT;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

sampler Sampler2 = 
sampler_state {
    Texture = <texture2>;
    MipFilter = LINEAR;
    MinFilter = POINT;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

float2 camera_position;
float uv_scales[2];
float2 uv_offsets[2];
float2 cos_sin[2];
float4 multiply_colors[2];
float4 add_colors[2];


float2 rotate(float2 uv, float2 cos_sin) {
    float ct = cos_sin.x;
    float st = cos_sin.y;

    float2 result;
    result.x = uv.x * ct + uv.y * st;
    result.y = uv.x * -st + uv.y * ct;

    return result;
}

float2 transform_uv(float2 pos, float scale, float2 offset, float2 cos_sin) {
    float2 uv = (pos + offset) * scale;
    uv = rotate(uv, cos_sin);

    return uv;
}


VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;

    float2 pos = input_position.xy + camera_position;

    float2 uv1 = transform_uv(pos, uv_scales[0], uv_offsets[0], cos_sin[0]);
    float2 uv2 = transform_uv(pos, uv_scales[1], uv_offsets[1], cos_sin[1]);

    output.uv1 = uv1;
    output.uv2 = uv2;

    return output;
}


struct PS_OUTPUT {
    float4 color : COLOR0;  // Pixel color    
};


float3 blend(float3 a, float4 b) {
    float t = b.w;
    return a + t * (b.xyz - a);
}

PS_OUTPUT pixel_shader(VS_OUTPUT input) {
    PS_OUTPUT output;

    float4 color1 = tex2D(Sampler1, input.uv1);
    float4 color2 = tex2D(Sampler2, input.uv2);

    color1 *= multiply_colors[0];
    color2 *= multiply_colors[1];

    float k = 1;
    color1 += add_colors[0]*k;
    color2 += add_colors[1]*k;

    float3 color12 = blend(color1, color2);
    output.color.xyz = input.color.xyz * color12;
    output.color.a = max(color1.a, color2.a);
//    output.color.a = 0.5;
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_1_1 pixel_shader();

        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;  
        DestBlend = InvSrcAlpha;
        AlphaTestEnable = True;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}


