struct VS_OUTPUT {
    float4 position   : POSITION;
    float4 color      : COLOR0;
    float2 uv1        : TEXCOORD0;
    float2 uv2        : TEXCOORD1;
    float2 uv3        : TEXCOORD2;
    float2 uv4        : TEXCOORD3;
};

float4x4 object_to_proj_matrix;


texture texture1;
texture texture2;
texture texture3;
texture texture4;

sampler Sampler1 = 
sampler_state {
    Texture = <texture1>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

sampler Sampler2 = 
sampler_state {
    Texture = <texture2>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

sampler Sampler3 = 
sampler_state {
    Texture = <texture3>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

sampler Sampler4 = 
sampler_state {
    Texture = <texture4>;
    MipFilter = LINEAR;
    MinFilter = LINEAR;
    MagFilter = LINEAR;
    AddressU = Wrap;
    AddressV = Wrap;
    SRGBTEXTURE = false;
};

float2 camera_position;
float uv_scales[4];
float2 uv_offsets[4];
float2 cos_sin[4];
float4 multiply_colors[4];
float4 add_colors[4];


float2 rotate(float2 uv, float2 cos_sin) {
    float ct = cos_sin.x;
    float st = cos_sin.y;

    float2 result;
    result.x = uv.x * ct + uv.y * st;
    result.y = uv.x * -st + uv.y * ct;

    return result;
}

float2 transform_uv(float2 pos, float scale, float2 offset, float2 cos_sin) {
    float2 uv = (pos + offset) * scale;
    uv = rotate(uv, cos_sin);

    return uv;
}


VS_OUTPUT vertex_shader(float4 input_position : POSITION, 
                        float4 color : COLOR0) {
    VS_OUTPUT output;
    output.position = mul(input_position, object_to_proj_matrix);
    output.color = color;

    float2 pos = input_position.xy + camera_position;

    float2 uv1 = transform_uv(pos, uv_scales[0], uv_offsets[0], cos_sin[0]);
    float2 uv2 = transform_uv(pos, uv_scales[1], uv_offsets[1], cos_sin[1]);
    float2 uv3 = transform_uv(pos, uv_scales[2], uv_offsets[2], cos_sin[2]);
    float2 uv4 = transform_uv(pos, uv_scales[3], uv_offsets[3], cos_sin[3]);

    output.uv1 = uv1;
    output.uv2 = uv2;
    output.uv3 = uv3;
    output.uv4 = uv4;

    return output;
}


struct PS_OUTPUT {
    float4 color : COLOR0;  // Pixel color    
};


float3 blend(float3 a, float4 b) {
    float t = b.w;
    return a + t * (b.xyz - a);
}

PS_OUTPUT pixel_shader(VS_OUTPUT input) {
    PS_OUTPUT output;

    float4 color1 = tex2D(Sampler1, input.uv1);
    float4 color2 = tex2D(Sampler2, input.uv2);
    float4 color3 = tex2D(Sampler3, input.uv3);
    float4 color4 = tex2D(Sampler4, input.uv4);

    color1 *= multiply_colors[0];
    color2 *= multiply_colors[1];
    color3 *= multiply_colors[2];
    color4 *= multiply_colors[3];

    color1 += add_colors[0];
    color2 += add_colors[1];
    color3 += add_colors[2];
    color4 += add_colors[3];

    float3 color34 = blend(color4.xyz, color3);
    float3 color234 = blend(color34, color2);
    float3 color1234 = blend(color234, color1);

    output.color.xyz = input.color.xyz * color1234;
    output.color.a = max(color1.a, color2.a);
    output.color.a = max(output.color.a, color3.a);
    output.color.a = max(output.color.a, color4.a);
//    output.color.a = color1.a + color2.a + color3.a + color4.a;
//output.color.rgb = float3(1, 0, 0);
    return output;
}

technique render {
    pass P0 {
        VertexShader = compile vs_1_1 vertex_shader();
        PixelShader  = compile ps_2_0 pixel_shader();

        AlphaBlendEnable = True;
        SrcBlend = SrcAlpha;  
        DestBlend = InvSrcAlpha;
        AlphaTestEnable = True;

        CullMode = None;
        ZEnable = False;
        ZWriteEnable = False;
    }
}



